Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-cookie-parser
Version:    1.4.3
Release:    alt1_7
Summary:    A Node.js module for cookie parsing with signatures
License:    MIT
URL:        https://github.com/expressjs/cookie-parser
Source0:    https://github.com/expressjs/cookie-parser/archive/%{version}/cookie-parser-%{version}.tar.gz

BuildArch:  noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(cookie)
BuildRequires:  npm(cookie-signature)

%if 0%{?enable_tests}
BuildRequires:  mocha node-mocha
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
Parse Cookie header and populate req.cookies with an object keyed by the
cookie names. Optionally you may enabled signed cookie support by passing a
secret string, which assigns req.secret so it may be used by other middleware.


%prep
%setup -q -n cookie-parser-%{version}

%nodejs_fixdep cookie '0.x'
%nodejs_fixdep cookie-signature '1.x'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/cookie-parser
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/cookie-parser

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'

%if 0%{?enable_tests}
mocha --reporter spec --bail --check-leaks test/
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/cookie-parser


%changelog
