Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# This macro is needed at the start for building on EL6


%global barename csslint

Name:               nodejs-csslint
Version:            0.10.0
Release:            alt1_8
Summary:            CSSLint

License:            MIT
URL:                https://www.npmjs.org/package/csslint
Source0:            http://registry.npmjs.org/%{barename}/-/%{barename}-%{version}.tgz
BuildArch:          noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:      %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:      rpm-build-nodejs node-devel

BuildRequires:      npm(parserlib)

Requires:           npm(parserlib)
Source44: import.info

%description
CSSLint is a tool to help point out problems with your CSS code. It does
basic syntax checking as well as applying a set of rules to the code that
look for problematic patterns or signs of inefficiency. The rules are all
pluggable, so you can easily write your own or omit ones you don't want.

You can find information about both using CSS Lint and contributing to the
project in the wiki: https://github.com/stubbornella/csslint/wiki

%prep
%setup -q -n package

# Remove bundled node_modules if there are any..
rm -rf node_modules/

%nodejs_fixdep --caret

%build
%nodejs_symlink_deps --build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/csslint
cp -pr package.json lib \
    %{buildroot}%{nodejs_sitelib}/csslint

%nodejs_symlink_deps

%files
%doc README.md
%{nodejs_sitelib}/csslint/

%changelog
