Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global enable_tests 1

%global packagename dateformat

Name:       nodejs-dateformat
Version:    3.0.3
Release:    alt1_6
Summary:    Steven Levithan's excellent dateFormat() function for Node.js
License:    MIT
URL:        https://github.com/felixge/node-dateformat
Source0:    https://registry.npmjs.com/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:        tests-%{version}.tar.bz2
Source10:       dl-tests.sh

# Patch to fix failing test.
# see also https://github.com/felixge/node-dateformat/issues/41
Patch0:     dateformat-fix-unit-test.patch

BuildArch:  noarch

BuildRequires:  rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(underscore)
%endif
Source44: import.info

%description
This is a JavaScript port of Steven Levithan's excellent dateFormat()
function, which provides a simple way to format dates and times
according to a user-specified mask.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package
cd test
%patch0 -p1

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/dateformat
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/dateformat

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
TZ="UTC" %{_bindir}/mocha -R spec
%endif


%files
%doc Readme.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/dateformat


%changelog
