Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-diff
Version:    1.0.8
Release:    alt1_11
Summary:    A JavaScript text diff implementation for Node.js
# LICENSE text is included in README.md
License:    BSD
URL:        https://github.com/kpdecker/jsdiff
Source0:    http://registry.npmjs.org/diff/-/diff-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:    tests-v%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(colors)
BuildRequires:  npm(mocha)
BuildRequires:  npm(should)
%endif
Source44: import.info

%description
%{summary}


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/diff
cp -pr package.json diff.js \
    %{buildroot}%{nodejs_sitelib}/diff

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%{nodejs_sitelib}/mocha/bin/mocha test/*.js
%endif


%files
%doc README.md
%{nodejs_sitelib}/diff


%changelog
