Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename difflib
%global enable_tests 1

Name:		nodejs-difflib
Version:	0.2.4
Release:	alt1_10
Summary:	Text diff library ported from Python's difflib module

License:	Python
# License text is at the bottom of README.md
URL:		https://github.com/qiao/difflib.js.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

Patch0:		difflib-0.2.4-fix-test-keywords.patch
# coffee-script no longer exports a "RESERVED" array of reserved keywords, so
# for now we'll manually copy that list of words into the test.  So much work
# for such a silly little test, but it holds true to the original intent.

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	coffee-script
BuildRequires:	mocha node-mocha
BuildRequires:	npm(heap)
BuildRequires:	npm(should)
%endif
Source44: import.info

%description
Text diff library ported from Python's difflib module


%prep
%setup -q -n package
%patch0 -p1

# remove pre-compiled version
rm lib/difflib.js

%nodejs_fixdep heap '^0.2.0'

%build
%{_bindir}/coffee -c -b -o lib/ src/difflib.coffee

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%{_bindir}/coffee -c -b test/*.coffee
%{_bindir}/mocha --require should -R spec --ui qunit
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference README.md
# license is at the bottom of README.md, so include it in both docs and license
%{nodejs_sitelib}/%{packagename}



%changelog
