Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename docopt
%global enable_tests 1

Name:		nodejs-docopt
Version:	0.6.2
Release:	alt1_8
Summary:	A command line option parser that will make you smile

License:	MIT
URL:		https://github.com/scarnie/docopt.coffee.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The example files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	examples-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	coffee-script
BuildRequires:	mocha
BuildRequires:	npm(chai)
%endif
Source44: import.info

%description
A command line option parser that will make you smile


%prep
%setup -q -n package
# setup the examples
%setup -q -T -D -a 1 -n package

# remove the pre-compiled script
rm docopt.js

%build
%{_bindir}/coffee -c docopt.coffee

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
#%{_bindir}/mocha --compilers coffee:coffee-script/register -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md examples/
%doc --no-dereference LICENSE-MIT
%{nodejs_sitelib}/%{packagename}



%changelog
