Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-ejs
Version:    1.0.0
Release:    alt1_12
Summary:    Embedded JavaScript templates for Node.js
# License text is included in Readme.md
License:    MIT
URL:        https://github.com/visionmedia/ejs
Source0:    http://registry.npmjs.org/ejs/-/ejs-%{version}.tgz

# Add patch to tests to bring up to a more modern 'should' syntax
Patch0:	    nodejs-ejs_fix-should-syntax.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(should)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package

%patch0 -p1


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/ejs
cp -pr package.json ejs.js ejs.min.js index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/ejs

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha --require should --reporter spec
%endif


%files
%doc History.md Readme.md examples/
%{nodejs_sitelib}/ejs


%changelog
