Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# tests are disabled due to missing packages in Fedora
%global enable_tests 0
%global module_name emojione

Name:           nodejs-%{module_name}
Version:        2.2.7
Release:        alt2_8
Summary:        EmojiOne is a complete set of emojis designed for the web
# Artwork included is in CC-BY-SA license
# Non-Artwork files are under MIT license
License:        MIT and CC-BY-SA
URL:            http://www.emojione.com
Source0:        http://registry.npmjs.org/%{module_name}/-/%{module_name}-%{version}.tgz
Patch1:         %name-xx-build.patch
BuildArch:      noarch
BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  nodejs-grunt-cli
BuildRequires:  nodejs-grunt-contrib-cssmin
BuildRequires:  nodejs-grunt-contrib-jshint
BuildRequires:  nodejs-grunt-contrib-qunit
BuildRequires:  nodejs-grunt-contrib-sass
BuildRequires:  nodejs-grunt-contrib-uglify
BuildRequires:  nodejs-grunt-contrib-watch
BuildRequires:  nodejs-grunt-imageoptim
BuildRequires:  nodejs-grunt-jsonlint
BuildRequires:  nodejs-grunt-spritesmith
BuildRequires:  nodejs-grunt-svgstore
%endif

Requires:       %{name}-json = %{version}-%{release}
Source44: import.info

%description
EmojiOne is a complete set of emojis designed for the web. It includes
libraries to easily convert unicode characters to shortnames (:smile:)
and shortnames to our custom emoji images. PNG and SVG formats provided
for the emoji images.


%package json
Group: Development/Other
Summary:        EmojiOne utility for Json files

%description json
This utility provides Json files which can be utilized by other packages.


%package android
Group: Development/Other
Summary:        EmojiOne utility for Android
Requires:       %{name} = %{version}-%{release}

%description android
This utility provides a method to convert from shortname to unicode characters.


%package awesome
Group: Development/Other
Summary:        Emojione awesome
Requires:       %{name} = %{version}-%{release}

%description awesome
EmojiOne Awesome is for front end developers who just wanna drop an emoji on a
page without using any sorts of scripts. 


%package meteor
Group: Development/Other
Summary:        EmojiOne utility for Meteor
Requires:       %{name} = %{version}-%{release}

%description meteor
This utility provides a method to convert from shortname to unicode characters.


%package ios
Group: Development/Other
Summary:        EmojiOne utility for iOS
Requires:       %{name} = %{version}-%{release}

%description ios
EmojiOne utility is for iOS.

%package -n python-module-nodejs-emojione
Group: Development/Other
Summary:        EmojiOne utility for Python
Requires:       %{name} = %{version}-%{release}

%description -n python-module-nodejs-emojione
EmojiOne utility is for Python.

%package swift
Group: Development/Other
Summary:        EmojiOne utility for Swift
Requires:       %{name} = %{version}-%{release}

%description swift
EmojiOne utility is for Swift.

%prep
%setup -q -c %{name}-%{version}
%patch1 -p1 -b .build
chmod a+x package/lib/python/emojipy/*.py
find . -name "*.js" -exec chmod 644 {} \;

%build
# nothing to build

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{module_name}
cp -R package/* %{buildroot}%{nodejs_sitelib}/%{module_name}
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/CONTRIBUTING.md
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/LICENSE.md
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/README.md
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/lib/tests.md
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/lib/android/README.md
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/lib/emojione-awesome/README.md
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/lib/ios/README.md
rm %{buildroot}%{nodejs_sitelib}/%{module_name}/lib/python/README.md

# https://github.com/Ranks/emojione/issues/295
rm -rf %{buildroot}%{nodejs_sitelib}/%{module_name}/assets/fonts

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
grunt travis
%endif

%files
%doc --no-dereference package/LICENSE.md
%doc package/CONTRIBUTING.md package/README.md package/lib/tests.md
%dir %{nodejs_sitelib}/%{module_name}/
%dir %{nodejs_sitelib}/%{module_name}/lib
%{nodejs_sitelib}/%{module_name}/lib/js
%{nodejs_sitelib}/%{module_name}/gruntfile.js
%{nodejs_sitelib}/%{module_name}/bower.json
%{nodejs_sitelib}/%{module_name}/assets

%files json
%doc --no-dereference package/LICENSE.md
%{nodejs_sitelib}/%{module_name}/emoji*.json
%{nodejs_sitelib}/%{module_name}/package.js
%{nodejs_sitelib}/%{module_name}/package.json

%files android
%doc package/lib/android/README.md
%{nodejs_sitelib}/%{module_name}/lib/android

%files awesome
%doc package/lib/emojione-awesome/README.md
%{nodejs_sitelib}/%{module_name}/lib/emojione-awesome

%files meteor
%{nodejs_sitelib}/%{module_name}/lib/meteor

%files ios
%doc package/lib/ios/README.md
%{nodejs_sitelib}/%{module_name}/lib/ios

%if 0
%files -n python-module-nodejs-emojione
%doc package/lib/python/README.md
%{nodejs_sitelib}/%{module_name}/lib/python
%endif

%files swift
%doc package/lib/swift/README.md
%{nodejs_sitelib}/%{module_name}/lib/swift

%changelog
