Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0
# Tests disabled due to unpackaged dependency on npm(espree), which depends
# on npm(acorn-jsx), which needs a newer version of npm(acorn), etc.

Name:       nodejs-estraverse
Version:    4.2.0
Release:    alt1_8
Summary:    ECMAScript JS AST traversal functions
License:    BSD
URL:        https://github.com/Constellation/estraverse
Source0:    http://registry.npmjs.org/estraverse/-/estraverse-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(coffee-script)
%if 0%{?enable_tests}
BuildRequires:  npm(chai)
BuildRequires:  npm(espree)
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/estraverse
cp -pr package.json estraverse.js \
    %{buildroot}%{nodejs_sitelib}/estraverse

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha --compilers coffee:coffee-script/register
%endif


%files
%{!?_licensedir:%global license %doc}
%doc LICENSE.BSD
%{nodejs_sitelib}/estraverse


%changelog
