Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename estree-walker

%global bootstrap 0

%global enable_tests 1

Name:		nodejs-estree-walker
Version:	0.5.2
Release:	alt1_5
Summary:	Traverse an ESTree-compliant AST

License:	MIT
URL:		https://github.com/Rich-Harris/estree-walker
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh
# rollup config
Source11:	https://raw.githubusercontent.com/Rich-Harris/estree-walker/v%{version}/rollup.config.js
# license
Source12:	LICENSE-MIT.txt


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(rollup)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(buble)
%endif
Source44: import.info

%description
Traverse an ESTree-compliant AST


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package

cp -p %{SOURCE11} .
cp -p %{SOURCE12} .


%build
%if !%{?bootstrap}
rm dist/*
rollup -i src/estree-walker.js -f umd -n estreeWalker -m -o dist/estree-walker.umd.js
rollup -i src/estree-walker.js -f es -m -o dist/estree-walker.es.js
%endif

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json dist/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/buble test/test.js -o test/test.es.js
NODE_ENV=test %{_bindir}/mocha -R spec test/test.es.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE-MIT.txt
%{nodejs_sitelib}/%{packagename}

%changelog
