Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename everything.js
%global enable_tests 1

Name:		nodejs-everything-dot-js
Version:	1.0.3
Release:	alt1_6
Summary:	A JS file with every ECMA-262 edition 5.1 grammatical production

License:	BSD
# License file requested upstream at https://github.com/michaelficarra/everything.js/issues/17
URL:		https://github.com/michaelficarra/everything.js
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
Source1:	https://raw.githubusercontent.com/michaelficarra/everything.js/master/LICENSE

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(esprima)
%endif
Source44: import.info

%description
A single javascript file that contains every ECMA-262 edition 5.1 grammatical
production


%prep
%setup -q -n package
cp -p %{SOURCE1} LICENSE



%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha --inline-diffs --check-leaks -u tdd -R spec test
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
