Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename expand-tilde
%global enable_tests 1

Name:		nodejs-expand-tilde
Version:	2.0.2
Release:	alt1_6
Summary:	Bash-like tilde expansion for node.js

License:	MIT
URL:		https://github.com/jonschlinkert/expand-tilde.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/jonschlinkert/expand-tilde/%{version}/test.js


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel

BuildRequires:	npm(os-homedir)
BuildRequires:	npm(is-windows)
BuildRequires:	npm(homedir-polyfill)
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Bash-like tilde expansion for node.js. Expands a leading tilde in a file path
to the user home directory, or `~+` to the cwd.


%prep
%setup -q -n package

# setup the tests
cp -p %{SOURCE1} .


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
