Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-expect-dot-js
Version:    0.2.0
Release:    alt1_17
Summary:    Behavior-driven development (BDD) style assertions for Node.js and the browser
# License text is included in README.md
License:    MIT
URL:        https://npmjs.org/package/expect.js
Source0:    http://registry.npmjs.org/expect.js/-/expect.js-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:    tests-0.2.0.tar.bz2
Source10:   dl-tests.sh

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

# 2 of the tests fail but have been fixed in upstream master.
# Cherry-pick the commits that fix this issue, but wait for the next
# upstream release to pull in the other changes.
Patch0:     %{name}-0.2.0-Pass-.fail-unit-test.patch
Patch1:     %{name}-0.2.0-Add-actual-expected-property-to-the-thrown-error.patch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
%endif

Patch2: 0001-Update-expected-test-values.patch
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -D -T -a 1 -n package
%patch0 -p1
%patch1 -p1
%patch2 -p1


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/expect.js
cp -pr package.json expect.js \
    %{buildroot}%{nodejs_sitelib}/expect.js

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha --require ./test/common \
    --reporter dot --growl test/expect.js
%endif


%files
%doc History.md README.md
%{nodejs_sitelib}/expect.js


%changelog
