Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-express-session
Version:    1.15.5
Release:    alt1_6
Summary:    A module to setup a session store with the given options
License:    MIT
URL:        https://github.com/expressjs/session
Source0:    https://registry.npmjs.org/express-session/-/express-session-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

Patch0:     nodejs-express-session-shouldjs.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(cookie)
BuildRequires:  npm(cookie-signature)
BuildRequires:  npm(crc)
BuildRequires:  npm(debug)
BuildRequires:  npm(depd)
BuildRequires:  npm(on-headers)
BuildRequires:  npm(uid-safe)
BuildRequires:  npm(parseurl)
BuildRequires:  npm(uid-safe)
BuildRequires:  npm(utils-merge)

%if 0%{?enable_tests}
BuildRequires:  npm(after)
BuildRequires:  npm(cookie-parser)
BuildRequires:  npm(mocha)
BuildRequires:  npm(supertest)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package

%nodejs_fixdep utils-merge '^1.0.0'
%nodejs_fixdep debug

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/express-session
cp -pr package.json index.js session/ \
    %{buildroot}%{nodejs_sitelib}/express-session

%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec -bail --ui bdd test/*.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/express-session


%changelog
