Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 32
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename fast-levenshtein
%global enable_tests 1

Name:		nodejs-fast-levenshtein
Version:	1.1.3
Release:	alt1_9
Summary:	Efficient implementation of Levenshtein algorithm

License:	MIT
URL:		https://github.com/hiddentao/fast-levenshtein.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh
# Adjust timeouts on tests
Patch0:		fast-levenshtein_adjust-timeouts.patch


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	uglify-js
%if 0%{?enable_tests}
BuildRequires:	node-mocha
BuildRequires:	npm(chai)
BuildRequires:	npm(lodash)
%endif
Source44: import.info

%description
Efficient implementation of Levenshtein algorithm with asynchronous callback
support.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package
#
%patch0 -p1


%build
%{_bindir}/uglifyjs levenshtein.js -o levenshtein.min.js

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"

%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md
%doc --no-dereference LICENSE.md
%{nodejs_sitelib}/%{packagename}


%changelog
