Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# test dependencies fake and far not packaged yet
%global enable_tests 0

Name:           nodejs-form-data
Version:        0.2.0
Release:        alt1_10
Summary:        A module to create readable "multipart/form-data" streams

License:        MIT
URL:            https://github.com/form-data/form-data
Source0:        https://github.com/form-data/form-data/archive/0.2/form-data-%{version}.tar.gz
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(async)
BuildRequires:  npm(combined-stream)
BuildRequires:  npm(mime-types)

%if 0%{?enable_tests}
BuildRequires:  npm(fake)
BuildRequires:  npm(far)
BuildRequires:  npm(formidable)
BuildRequires:  npm(request)
%endif
Source44: import.info

%description
A module to create readable "multipart/form-data" streams.  Can be used to
submit forms and file uploads to other web applications.


%prep
%setup -q -n form-data-0.2
%nodejs_fixdep async "^1.5.0"
%nodejs_fixdep mime-types "^2.1.7"
%nodejs_fixdep combined-stream "^1.0.5"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/form-data
cp -pr package.json lib %{buildroot}%{nodejs_sitelib}/form-data


%check
%nodejs_symlink_deps --check
%__nodejs -e "require('./')"
%if 0%{?enable_tests}
%__nodejs test/run.js
%endif


%files
%doc Readme.md
%doc --no-dereference License
%{nodejs_sitelib}/form-data


%changelog
