Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global enable_tests 1
%global module_name fs-ext

Name:           nodejs-%{module_name}
Version:        1.3.0
Release:        alt1_2
Summary:        Extensions to core 'fs' module for Node.js

License:        MIT
URL:            https://github.com/baudehlo/node-fs-ext/
Source0:        https://registry.npmjs.org/%{module_name}/-/%{module_name}-%{version}.tgz

BuildRequires:  node-gyp
BuildRequires:  node-devel rpm-build-nodejs
BuildRequires:  npm(nan) >= 2.0.0

Requires:       npm(nan)

BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
%{summary}.

%prep
%setup -q -n package

rm -rf node_modules
%nodejs_fixdep nan

%build
%nodejs_symlink_deps --build
export CXXFLAGS="%{optflags}"
export LDFLAGS="%{?__global_ldflags} -Wl,-z,undefs"
node-gyp rebuild
rm -rf node_modules

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{module_name}/build
cp -pr fs-ext.js package.json %{buildroot}%{nodejs_sitelib}/%{module_name}
cp -p  build/Release/%{module_name}.node %{buildroot}%{nodejs_sitelib}/%{module_name}/build/
sed -i -e 's|build/Release|build|g' \
    %{buildroot}%{nodejs_sitelib}/%{module_name}/fs-ext.js

# Fix permissions
chmod 755 %{buildroot}%{nodejs_sitelib}/%{module_name}/build/%{module_name}.node

#%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} tests/test-fs-fcntl.js
%{__nodejs} tests/test-fs-flock.js
%{__nodejs} tests/test-fs-flock_stress.js
%{__nodejs} tests/test-fs-seek.js
%{__nodejs} tests/test-fs-seek_stress.js
%endif

%files
%doc README.md example.js
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{module_name}

%changelog
