Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename get-value

# tests disabled due to large number of missing dependencies
%global enable_tests 0

Name:		nodejs-get-value
Version:	2.0.6
Release:	alt1_6
Summary:	Use property paths (a.b.c) to get a nested value from an object

License:	MIT
URL:		https://github.com/jonschlinkert/get-value
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/jonschlinkert/get-value/master/test.js

# Source2 is generated by running Source10, which pulls from the upstream
# version control repository.
Source2:	benchmark-%{version}.tar.bz2
Source10:	dl-tests.sh


# Patch the package.json file to add 'mocha' as a devDependency:
Patch1:		nodejs-get-value_add-mocha-dep.patch


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(ansi-bold)
BuildRequires:	npm(arr-reduce)
BuildRequires:	npm(benchmarked)
BuildRequires:	npm(dot-prop)
BuildRequires:	npm(getobject)
BuildRequires:	npm(isobject)
BuildRequires:	npm(matched)
BuildRequires:	npm(minimist)
%endif
Source44: import.info

%description
Use property paths (`a.b.c`) to get a nested value from an object.


%prep
%setup -q -n package
%patch1 -p1

# setup the tests
cp -p %{SOURCE1} .
# setup the benchmark
%setup -q -T -D -a 2 -n package


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
