Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-glob
Version:        6.0.4
Release:        alt1_9
Summary:        A little globber for Node.js

License:        BSD
URL:            https://github.com/isaacs/node-glob
Source0:        https://github.com/isaacs/node-glob/archive/v%{version}/%{name}-%{version}.tar.gz
# Fix tests to work with older version of tap
Patch0:         nodejs-glob-tap.patch
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(tap)
BuildRequires:  npm(inflight)
BuildRequires:  npm(path-is-absolute)
BuildRequires:  npm(rimraf)
%endif
Source44: import.info


%description
This is a glob implementation in pure JavaScript. It uses the minimatch library
to do its matching.


%prep
%setup -q -n node-glob-%{version}
%patch0 -p1

%nodejs_fixdep once "^1.1.1"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/glob
cp -pr package.json glob.js sync.js common.js \
  %{buildroot}%{nodejs_sitelib}/glob
%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%tap test/*.js
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md examples
%doc --no-dereference LICENSE
%{nodejs_sitelib}/glob


%changelog
