Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename global-prefix
%global enable_tests 1

Name:		nodejs-global-prefix
Version:	1.0.2
Release:	alt1_6
Summary:	Get the npm global path prefix

License:	MIT
URL:		https://github.com/jonschlinkert/global-prefix.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Also, the 0.1.4 release has not yet been tagged in github
Source1:	https://raw.githubusercontent.com/jonschlinkert/global-prefix/%{version}/test.js
# Fix the path in the tests, as the test defaults to /usr/local instead of /usr
Patch0:		nodejs-global-prefix_fix-test-path.patch


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(expand-tilde)
BuildRequires:	npm(osenv)
BuildRequires:	npm(ini)
BuildRequires:	npm(is-windows)
BuildRequires:	npm(which)

%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Get the npm global path prefix.


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .
# patch the test
#%patch0 -p1


%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
NODE_ENV=test %{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%{!?_licensedir:%global license %doc}
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
