Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename globby
%global enable_tests 1

Name:		nodejs-globby
Version:	4.0.0
Release:	alt1_9
Summary:	Extends `glob` with support for multiple patterns and exposes a Promise API

License:	MIT
URL:		https://github.com/sindresorhus/globby
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/sindresorhus/globby/v%{version}/test.js

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha
BuildRequires:	npm(array-union)
BuildRequires:	npm(arrify)
BuildRequires:	npm(glob)
BuildRequires:	npm(object-assign)
BuildRequires:	npm(pify)
BuildRequires:	npm(pinkie-promise)
%endif
Source44: import.info

%description
Extends `glob` with support for multiple patterns and exposes a Promise API


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .
%nodejs_fixdep array-union "^2.1.0"
%nodejs_fixdep arrify "^2.0.1"


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo "Tests disabled..."
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference license
%{nodejs_sitelib}/%{packagename}


%changelog
