Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# tests diabled due to failing "ENOENT" tests
%global enable_tests 1

Name:           nodejs-graceful-fs
Version:        4.2.0
Release:        alt1_4
Summary:        A drop-in replacement for fs, making various improvements
License:        BSD
URL:            https://github.com/isaacs/node-graceful-fs
Source0:        https://github.com/isaacs/node-graceful-fs/archive/v%{version}/%{name}-%{version}.tar.gz
# Work around limitations in old version of tap
Patch0:         nodejs-graceful-fs-tap.patch
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(tap)
BuildRequires:  npm(rimraf)
Source44: import.info

%description
A drop-in replacement for fs, making various improvements.

The improvements are meant to normalize behavior across different
platforms and environments, and to make filesystem access more
resilient to errors.

Improvements over fs module

* Queues up open and readdir calls, and retries them once something
  closes if there is an EMFILE error from too many file descriptors.
* Fixes lchmod for Node versions prior to 0.6.2.
* Implements fs.lutimes if possible. Otherwise it becomes a noop.
* Ignores EINVAL and EPERM errors in chown, fchown or lchown if the
  user isn't root.
* Makes lchmod and lchown become noops, if not available.
* Retries reading a file if read results in EAGAIN error.

On Windows, it retries renaming a file for up to one second if EACCESS
or EPERM error occurs, likely because antivirus software has locked the
directory.


%prep
%setup -q -n node-graceful-fs-%{version}
%patch0 -p1



%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/graceful-fs
cp -p package.json graceful-fs.js polyfills.js legacy-streams.js clone.js \
    %{buildroot}%{nodejs_sitelib}/graceful-fs
%nodejs_symlink_deps



%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
# Disable test that needs import-fresh
rm test/avoid-memory-leak.js
%{_bindir}/tap test/*.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/graceful-fs


%changelog
