Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global enable_tests 0

Name:           nodejs-hawk
Version:        4.1.2
Release:        alt1_8
Summary:        HTTP Hawk authentication scheme
License:        BSD
URL:            https://github.com/hueniverse/hawk
Source0:        https://registry.npmjs.org/hawk/-/hawk-%{version}.tgz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(boom)
BuildRequires:  npm(cryptiles)
BuildRequires:  npm(hoek)
BuildRequires:  npm(sntp)

%if 0%{?enable_tests}
BuildRequires:  npm(lab)
BuildRequires:  npm(code)
%endif
Source44: import.info

%description
Hawk is an HTTP authentication scheme using a message authentication code (MAC)
algorithm to provide partial HTTP request cryptographic verification.

%prep
%setup -q -n package

%nodejs_fixdep cryptiles "^2.0.5"
%nodejs_fixdep boom "^2.10.1"
%nodejs_fixdep hoek "^0.9.1"
chmod a-x README.md LICENSE package.json client.js example/* images/* lib/*
sed -i 's/\r$//' README.md
sed -i 's/\r$//' example/usage.js


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/hawk
cp -pr package.json lib %{buildroot}%{nodejs_sitelib}/hawk
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%__nodejs -e "require('./')"
%if 0%{?enable_tests}
%{nodejs_sitelib}/lab/bin/lab -a code -t 100 -L
%endif


%files
%doc README.md example images
%doc --no-dereference LICENSE
%{nodejs_sitelib}/hawk


%changelog
