Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 29
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

# This package requires the grunt stack, but grunt also requires this package.
# Before grunt is available, this will need to be built manually.
%global enable_grunt 0

Name:       nodejs-hooker
Version:    0.2.3
Release:    alt1_13
Summary:    Monkey-patch (hook) functions for debugging
License:    MIT
URL:        https://github.com/cowboy/javascript-hooker
Source0:    http://registry.npmjs.org/hooker/-/hooker-%{version}.tgz

# This is taken from the upstream version control repository.
Patch0:     %{name}-0.2.3-Updating-gruntfile-to-grunt-0.3.0-format.patch
# These two patches update grunt.js for use with grunt 0.4.0.
# Pull request sent: https://github.com/cowboy/javascript-hooker/pull/3
Patch1:     %{name}-0.2.3-Rename-grunt.js-to-Gruntfile.js.patch
Patch2:     %{name}-0.2.3-Update-Gruntfile.js-for-use-with-grunt-0.4.0.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  uglify-js

%if 0%{?enable_tests}
BuildRequires:  npm(nodeunit)
%endif

%if 0%{?enable_grunt}
BuildRequires:  npm(grunt-cli)
BuildRequires:  npm(grunt-contrib-nodeunit)
BuildRequires:  npm(grunt-contrib-uglify)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%patch0 -p1
%patch1 -p1
%patch2 -p1
%nodejs_symlink_deps --check


%build
%if 0%{?enable_grunt}
grunt uglify
%else
# Add copyright header to the minified script.
head -n 8 lib/hooker.js > dist/ba-hooker.min.js.new
# Minify and preserve timestamp.
/usr/bin/uglifyjs dist/ba-hooker.js -m -c >> dist/ba-hooker.min.js.new
touch -r dist/ba-hooker.min.js dist/ba-hooker.min.js.new
mv dist/ba-hooker.min.js{.new,}
%endif


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/hooker
cp -pr package.json child.js dist/ lib/ parent.js \
    %{buildroot}%{nodejs_sitelib}/hooker

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%if 0%{?enable_grunt}
grunt nodeunit
%else
%{nodejs_sitelib}/nodeunit/bin/nodeunit test/*.js
%endif
%endif


%files
%doc LICENSE-MIT README.md
%{nodejs_sitelib}/hooker


%changelog
