Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename http-errors
%global enable_tests 1

Name:		nodejs-http-errors
Version:	1.6.2
Release:	alt1_5
Summary:	Create HTTP errors for Express, Koa, Connect, etc. with ease

License:	MIT
URL:		https://github.com/jshttp/http-errors
Source0:	https://github.com/jshttp/http-errors/archive/%{version}.tar.gz


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif


BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(statuses)
BuildRequires:	npm(inherits)
%if 0%{?enable_tests}
BuildRequires:	mocha
BuildRequires:	npm(depd)
BuildRequires:	npm(setprototypeof)
%endif

Requires:	node
Source44: import.info

%description
Create HTTP errors for Express, Koa, Connect, etc. with ease

%prep
%setup -q -n %{packagename}-%{version}
%nodejs_fixdep inherits "^2.0.1"
%nodejs_fixdep --caret setprototypeof


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
/usr/bin/mocha -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc README.md HISTORY.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
