Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-iconv-lite
Version:        0.4.18
Release:        alt1_7
Summary:        Convert character encodings in pure JavaScript

License:        MIT
URL:            https://github.com/ashtuchkin/iconv-lite/archive/
Source0:        https://github.com/ashtuchkin/iconv-lite/archive/v%{version}/%{name}-%{version}.tar.gz
# https://github.com/ashtuchkin/iconv-lite/commit/be3c9e5728352bf8924c8d340423b99812e27472
Patch0:         nodejs-iconv-lite-node10.patch
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(iconv)
BuildRequires:  npm(mocha)
BuildRequires:  npm(semver)
Source44: import.info
#BuildRequires:  npm(unorm)

%description
%{summary}.


%prep
%setup -q -n iconv-lite-%{version}
%patch0 -p1



%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/iconv-lite
cp -pr package.json encodings/ lib/ \
    %{buildroot}%{nodejs_sitelib}/iconv-lite
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
# Remove tests failing due to glibc based iconv
rm test/dbcs-test.js
# Remove tests that require unorm
rm test/sbcs-test.js
mocha --reporter spec --grep .


%files
%doc README.md Changelog.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/iconv-lite


%changelog
