Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:           nodejs-inherits
Version:        2.0.3
Release:        alt1_7
Summary:        A tiny simple way to do classic inheritance in js
License:        WTFPL
URL:            https://github.com/isaacs/inherits
Source0:        https://registry.npmjs.org/inherits/-/inherits-%{version}.tgz
Source1:        https://raw.github.com/isaacs/inherits/112807f2670160b6e3bafdf39e395c10ae7d0fac/LICENSE
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
cp -p %{SOURCE1} LICENSE


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/inherits@2
cp -pr inherits.js package.json %{buildroot}%{nodejs_sitelib}/inherits@2
ln -sf inherits@2 %{buildroot}%{nodejs_sitelib}/inherits
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check

# Upstream no longer includes test.js with its tarballs
# %__nodejs test.js


# there have been reports that the symlinks are messed up when upgrading
# from older versions, so let's make sure everything's copacetic
%triggerun -- nodejs-inherits < 2.0.0-4
ln -sf inherits@2 %{nodejs_sitelib}/inherits
%{__python} <<EOF
import json, os, sys

for moddir in os.listdir('%{nodejs_sitelib}'):
    if os.path.isdir(moddir):
        md = json.load(open(os.path.join(moddir, 'package.json')))
        
        if 'dependencies' in md and 'inherits' in md['dependencies']:
            if isinstance(md['dependencies'], dict) and '1' in md['dependencies']['inherits']:
                src = os.path.join('%{nodejs_sitelib}', 'inherits@1')
            else:
                src = os.path.join('%{nodejs_sitelib}', 'inherits@2')
                
            dest = os.path.join('%{nodejs_sitelib}', moddir, 'node_modules/inherits')
            
            if not os.path.realpath(dest) == src:
                try:
                    os.unlink(dest)
                except OSError:
                    pass
                    
                try:
                    os.symlink(src, dest)
                except OSError, e:
                    sys.stderr.write(e + '\n')
EOF


# rpm blows up if you try to replace a dir with a symlink or vice-versa
%pre
if [ -d %{nodejs_sitelib}/inherits ]; then
    mv %{nodejs_sitelib}/inherits '%{nodejs_sitelib}/inherits@2'
fi


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/inherits@2
%{nodejs_sitelib}/inherits


%changelog
