Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename ipaddr.js
%global enable_tests 0
# Tests disabled due to missing 'lab" test suite

Name:		nodejs-ipaddr-dot-js
Version:	1.5.2
Release:	alt1_7
Summary:	A library for manipulating IPv4 and IPv6 addresses in JavaScript

License:	MIT
URL:		https://github.com/whitequark/ipaddr.js
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(code)
BuildRequires:	npm(coffee-script)
BuildRequires:	npm(lab)
BuildRequires:	npm(nodeunit)
BuildRequires:	npm(uglify-js)
%endif

Requires:	node
Source44: import.info

%description
A library for manipulating IPv4 and IPv6 addresses in JavaScript.


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package



%build
# nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
ln -s %{nodejs_sitelib}/uglify-js %{buildroot}%{nodejs_sitelib}/uglify-js
/usr/bin/cake test
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
