Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename json3
%global enable_tests 1

Name:		nodejs-json3
Version:	3.3.2
Release:	alt1_7
Summary:	A modern JSON implementation compatible with nearly all JavaScript platforms

License:	MIT
URL:		https://github.com/bestiejs/json3
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh
# The tests in master are much better because they get rid of the "vendor"
# directory and use devDependencies instead
Source11:	https://raw.githubusercontent.com/bestiejs/json3/master/test/test_json3.js


BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	npm(spec)
%endif
Source44: import.info

%description
A modern JSON implementation compatible with nearly all JavaScript platforms.


%prep
%setup -q -n package

# setup the tests
%setup -q -T -D -a 1 -n package

cp -p %{SOURCE11} test/test_json3.js

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
mkdir node_modules
pushd node_modules
ln -s %{nodejs_sitelib}/spec
popd
%__nodejs test/test_*.js
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif

%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}

%changelog
