Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# test.js does not like being run in mock (ie, non-tty)
%global enable_tests 0

Name:       nodejs-keypress
Version:    0.2.1
Release:    alt1_11
Summary:    Make any Node ReadableStream emit "keypress" events
# License text is included in README.md
License:    MIT
URL:        https://github.com/TooTallNate/keypress
Source0:    http://registry.npmjs.org/keypress/-/keypress-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
Source44: import.info

%description
Previous to Node v0.8.x, there was an undocumented "keypress" event that
process.stdin would emit when it was a TTY. Some people discovered this
hidden gem, and started using it in their own code.

In Node v0.8.x, this "keypress" event does not get emitted by default,
but rather only when it is being used in conjunction with the readline
(or by extension, the repl) module.

This module is the exact logic from the node v0.8.x releases ripped out
into its own module.


%prep
%setup -q -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/keypress
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/keypress

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%__nodejs test.js
%endif


%files
%doc README.md
%{nodejs_sitelib}/keypress


%changelog
