Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-libxmljs
Version:    0.19.5
Release:    alt1_2
Summary:    Node.js module that provides libxml bindings for the v8 javascript engine
License:    MIT
URL:        https://github.com/polotek/libxmljs
Source0:    https://registry.npmjs.org/libxmljs/-/libxmljs-%{version}.tgz

# binding.gyp contains a dependency on the bundled libxml2
Patch0:     %{name}-0.18.7-remove-bundled-libxml.patch
# https://github.com/libxmljs/libxmljs/pull/552
Patch1:     %{name}-0.19.5-node12.patch

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  node-gyp
BuildRequires:  libxml2-devel
BuildRequires:  npm(nan) >= 2.0.4


%if 0%{?enable_tests}
BuildRequires:  npm(bindings)
BuildRequires:  npm(nodeunit)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%patch0 -p1
%patch1 -p1

%nodejs_fixdep bindings
%nodejs_fixdep --dev --move nan
%nodejs_fixdep --remove node-pre-gyp
rm -rf vendor/


%build
%nodejs_symlink_deps --build
export CXXFLAGS="%{optflags}"
export LDFLAGS="%{?__global_ldflags} -Wl,-z,undefs"
node-gyp configure
node-gyp build


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/libxmljs
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/libxmljs
mkdir -p %{buildroot}%{nodejs_sitelib}/libxmljs/build
install -p -D -m0755 build/Release/lib.target/xmljs.node \
    %{buildroot}%{nodejs_sitelib}/libxmljs/build/xmljs.node
%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
ln -s Release/lib.target/xmljs.node build/xmljs.node
%__nodejs --expose_gc %{nodejs_sitelib}/nodeunit/bin/nodeunit test
%endif


%files
%doc README.md examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/libxmljs


%changelog
