Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# Tests disabled due to missing dependencies
%global enable_tests 0

Name:       nodejs-load-grunt-tasks
Version:    5.1.0
Release:    alt1_1
Summary:    Load multiple grunt tasks using globbing patterns
License:    MIT
URL:        https://github.com/sindresorhus/load-grunt-tasks
Source0:    http://registry.npmjs.org/load-grunt-tasks/-/load-grunt-tasks-%{version}.tgz
# The npm tarball doesn't contain tests, so get it from the upstream github repo
Source1:    https://raw.githubusercontent.com/sindresorhus/load-grunt-tasks/v%{version}/gruntfile.js
# Include a copy of the MIT license to comply with license requirements.
Source2:    https://raw.githubusercontent.com/sindresorhus/load-grunt-tasks/v%{version}/license


BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  npm(multimatch)
BuildRequires:  npm(resolve-pkg)
BuildRequires:  npm(pkg-up)

%if 0%{?enable_tests}
BuildRequires:  npm(arrify)
BuildRequires:  npm(grunt-cli)
BuildRequires:  npm(grunt-contrib-clean)
BuildRequires:  npm(grunt-simple-mocha)
BuildRequires:  npm(grunt-svgmin)
%endif
Source44: import.info


%description
%{summary}.


%prep
%setup -q -n package
cp -p %{SOURCE1} .
cp -p %{SOURCE2} .

%nodejs_fixdep arrify "^2.0.1"
%nodejs_fixdep findup-sync
%nodejs_fixdep resolve-pkg

%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/load-grunt-tasks
cp -pr package.json *.js \
    %{buildroot}%{nodejs_sitelib}/load-grunt-tasks

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/grunt
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc readme.md
%doc --no-dereference license
%{nodejs_sitelib}/load-grunt-tasks


%changelog
