Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-ltx
Version:    0.5.0
Release:    alt1_10
Summary:    A Node.js module for parsing, modifying and building XML
License:    MIT
URL:        https://github.com/astro/ltx
Source0:    http://registry.npmjs.org/ltx/-/ltx-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(vows)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%nodejs_fixdep node-expat '~2.0'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/ltx
cp -pr package.json index.js lib/ \
    %{buildroot}%{nodejs_sitelib}/ltx

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%__nodejs test/dom-element-test.js
%__nodejs test/element-test.js
%__nodejs test/parse-test.js
%__nodejs test/unicode-test.js
%endif


%files
%doc LICENSE README.markdown
%{nodejs_sitelib}/ltx


%changelog
