Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-markdown
Version:        0.5.0
Release:        alt1_13
Summary:        A sensible Markdown parser for JavaScript
# Upstream have been informed about missing LICENSE file:
# https://github.com/evilstreak/markdown-js/issues/74
License:        MIT
URL:            https://github.com/evilstreak/markdown-js
Source0:        http://registry.npmjs.org/markdown/-/markdown-%{version}.tgz
# Source1 is generated by running Source10, which pulls from the upstream
# revision control repository.
Source1:        tests-v%{version}.tar.bz2
# Include a custom man page.
Source2:        md2html.1
Source10:       dl-tests.sh
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(tap)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%nodejs_fixdep nopt "^3.0.6"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/markdown
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/markdown
mkdir -p %{buildroot}%{nodejs_sitelib}/markdown/bin

install -p -D -m0755 bin/md2html.js \
    %{buildroot}%{nodejs_sitelib}/markdown/bin/md2html.js
mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/markdown/bin/md2html.js \
    %{buildroot}%{_bindir}/md2html

mkdir -p %{buildroot}%{_mandir}/man1
install -p -D -m0644 %{SOURCE2} %{buildroot}%{_mandir}/man1/md2html.1

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%tap test/*.t.js
%endif


%files
%doc Changes.markdown README.markdown
%{nodejs_sitelib}/markdown
%{_bindir}/md2html
%{_mandir}/man1/md2html.1*


%changelog
