Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename mdurl
%global enable_tests 1

Name:		nodejs-mdurl
Version:	1.0.1
Release:	alt1_10
Summary:	URL utilities for markdown-it

License:	MIT
URL:		https://github.com/markdown-it/mdurl.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif

Requires:	node

Provides:	bundled(nodejs)
Source44: import.info
# While it's probably overkill, this package contains a highly forked version
# of a small portion of nodejs, which is (as far as we can tell) based on
# https://github.com/nodejs/node/blob/913addbff5481567262c387cef9594f809e4ef83/lib/url.js
#
# The version in this package was specifically changed, with a long list of
# changes at the top of both README.md and the parse.js file.
#
# Out of an overabundance of caution, however, I'm adding this Provides line
# (even though I'd argue that this is a fork and not a bundled library)

%description
URL utilities for markdown-it


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package



%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
/usr/bin/mocha -R spec
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
