Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(IO/File.pm) perl(Text/Tabs.pm) perl(overload.pm) perl(re.pm)
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


Name:       nodejs-muffin
Version:    0.9.0
Release:    alt1_15
Summary:    Node.js module with handy helpers for building Cakefiles
# License text is included in Readme.md
License:    MIT
URL:        http://hornairs.github.com/muffin/
Source0:    http://registry.npmjs.org/muffin/-/muffin-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel
Requires:       cloc
Source44: import.info

%description
This Node.js module has handy helpers for building Cakefiles.

It has a set of generic high level file operations you don't want to implement
yourself, like copying files, CoffeeScript compilation and compile time
requiring, minification, and SLOC counting.


%prep
%setup -q -n package
rm -f deps/cloc.pl
rm -rf docs/public/fonts/
%nodejs_fixdep coffee-script '~1.4'
%nodejs_fixdep glob '~6.0.3'
%nodejs_fixdep prompt '~0.2'
%nodejs_fixdep q '~1.0'
%nodejs_fixdep q-io '~1.6'
%nodejs_fixdep snockets '~1.3'
%nodejs_fixdep temp '~0.5'
%nodejs_fixdep uglify-js '~2.2'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/muffin
cp -pr package.json deps/ lib/ \
    %{buildroot}%{nodejs_sitelib}/muffin

# Use system provided cloc.pl
ln -sf /usr/bin/cloc \
    %{buildroot}%{nodejs_sitelib}/muffin/deps/cloc.pl

%nodejs_symlink_deps


%files
%doc Readme.md docs/
%{nodejs_sitelib}/muffin


%changelog
