Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-multimatch
Version:        2.1.0
Release:        alt1_11
Summary:        Adds multiple patterns support to minimatch.match()
License:        MIT
URL:            https://github.com/sindresorhus/multimatch
Source0:        https://github.com/sindresorhus/multimatch/archive/v%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(array-differ)
BuildRequires:  npm(array-union)
BuildRequires:  npm(arrify)
BuildRequires:  npm(chai)
BuildRequires:  npm(minimatch)
BuildRequires:  npm(mocha)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n multimatch-%{version}

%nodejs_fixdep arrify "^2.0.1"
%nodejs_fixdep array-union "^2.1.0"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/multimatch
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/multimatch
%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{_bindir}/mocha --reporter spec
%endif


%files
%doc readme.md
%doc --no-dereference license
%{nodejs_sitelib}/multimatch


%changelog
