Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 0

Name:       nodejs-multiparty
Version:    3.2.4
Release:    alt1_11
Summary:    A multipart/form-data parser for Node.js which supports streaming
License:    MIT
URL:        https://github.com/andrewrk/node-multiparty
Source0:    http://registry.npmjs.org/multiparty/-/multiparty-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:    tests-%{version}.tar.bz2
Source10:   dl-tests.sh

# Use Node.js core instead of the forked npm(readable-stream).
Patch0:     %{name}-3.2.3-Use-Node.js-core.patch

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
# Not yet packaged for Fedora.
# BuildRequires:  npm(findit)
# BuildRequires:  npm(hashish)
BuildRequires:  npm(mkdirp)
BuildRequires:  npm(mocha)
BuildRequires:  npm(request)
BuildRequires:  npm(stream-counter)
BuildRequires:  npm(superagent)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package
%setup -q -T -D -a 1 -n package
%patch0 -p1
chmod 644 index.js

%nodejs_fixdep -r readable-stream
%nodejs_fixdep stream-counter '~0.2'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/multiparty
cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/multiparty

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
# /usr/bin/npm install findit@0.1.1
# /usr/bin/npm install hashish@0.0.4
/usr/bin/mocha --timeout 4000 --reporter spec --recursive test/test.js
%endif


%files
%doc CHANGELOG.md LICENSE README.md
%{nodejs_sitelib}/multiparty


%changelog
