Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat rpm-macros-nodejs
BuildRequires: gcc-c++
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-node-expat
Version:    2.3.18
Release:    alt1_4
Summary:    Fast libexpat XML SAX parser binding for Node.js
License:    MIT
URL:        https://github.com/node-xmpp/node-expat
Source0:    https://github.com/node-xmpp/node-expat/archive/v%{version}/node-expat-%{version}.tar.gz
# Use the system expat library
Patch0:     %{name}-2.3.18-system-expat.patch
# https://github.com/node-xmpp/node-expat/issues/125
Patch1:     %{name}-2.3.18-timing.patch

BuildRequires:  libexpat-devel
BuildRequires:  rpm-build-nodejs node-devel
BuildRequires:  node-gyp
BuildRequires:  npm(nan) >= 2.0.9

%if 0%{?enable_tests}
BuildRequires:  npm(vows)
BuildRequires:  npm(bindings)
BuildRequires:  npm(debug)
BuildRequires:  npm(iconv)
%endif

%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm}
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n node-expat-%{version}
%patch0 -p1
%patch1 -p1

%nodejs_fixdep bindings "^1.3.0"
rm -rf deps/


%build
%nodejs_symlink_deps --build
export CXXFLAGS="%{optflags}"
export LDFLAGS="%{?__global_ldflags} -Wl,-z,undefs"
node-gyp rebuild


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/node-expat
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/node-expat
mkdir -p %{buildroot}%{nodejs_sitelib}/node-expat/build
install -p -m0755 build/Release/node_expat.node \
    %{buildroot}%{nodejs_sitelib}/node-expat/build/node_expat.node
sed -i -e 's|build/Release|build|g' \
    %{buildroot}%{nodejs_sitelib}/node-expat/lib/node-expat.js

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/vows/bin/vows --spec ./test/**/*.js
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/node-expat


%changelog
