Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# needed for building on el6


# tests open browser windows which will require firefox and chrome in BR
%global enable_tests 0
%global srcname opn

%global commit0 80d06d7f4a7daa7a215bf9b0a2e530dc277497d8
%global shortcommit0 %(c=%{commit0}; echo ${c:0:7})
%global owner sindresorhus

Name:           nodejs-%{srcname}
Version:        3.0.3
Release:        alt1_7
Summary:        A better node-open which opens websites, files, executables
License:        MIT
URL:            https://github.com/%{owner}/%{srcname}
# test not in npm source, using github
Source0:        https://github.com/%{owner}/%{srcname}/archive/%{commit0}.tar.gz#/%{srcname}-%{shortcommit0}.tar.gz

BuildArch:      noarch

%if 0%{?rhel} == 6
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%else
%endif

BuildRequires:  rpm-build-nodejs node-devel
Requires:       xdg-utils

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(object-assign)
%endif
Source44: import.info

%description
%{summary}.

%prep
%setup -qn %{srcname}-%{commit0}

rm -rf node_modules

# delete bundled xdg-open
rm -f xdg-open

%nodejs_fixdep object-assign

%build
#nothing to do

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{srcname}

cp -pr package.json index.js \
    %{buildroot}%{nodejs_sitelib}/%{srcname}

# symlink to system xdg-open
ln -s %{_bindir}/xdg-open \
  %{buildroot}%{nodejs_sitelib}/%{srcname}/xdg-open

%nodejs_symlink_deps

%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
# symlink to system xdg-open
ln -s %{_bindir}/xdg-open xdg-open
mocha
%endif

%files
%{!?_licensedir:%global license %doc}
%doc readme.md
%doc --no-dereference license
%{nodejs_sitelib}/%{srcname}

%changelog
