Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename output-file-sync

# Tests disabled due to circular dependency on read-remove-file, which depends
# on this package
%global enable_tests 0

Name:		nodejs-output-file-sync
Version:	1.1.1
Release:	alt1_10
Summary:	Synchronously write a file and create its ancestor directories if needed

License:	MIT
URL:		https://github.com/shinnn/output-file-sync.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
Source1:	https://raw.githubusercontent.com/shinnn/output-file-sync/v%{version}/test.js



BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(xtend)
BuildRequires:	npm(mkdirp)
%if 0%{?enable_tests}
BuildRequires:	npm(read-remove-file)
BuildRequires:	npm(tape)
%endif
Source44: import.info

%description
Synchronously write a file and create its ancestor directories if needed


%prep
%setup -q -n package
# setup the tests
cp -p %{SOURCE1} .

chmod -x *

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{__nodejs} test.js | tap-spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
