Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:       nodejs-package
Version:    1.0.1
Release:    alt1_12
Summary:    Provides an easy way to export package.json data
# License text is contained within Readme.md
License:    MIT
URL:        https://github.com/vesln/package
Source0:    http://registry.npmjs.org/package/-/package-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(mocha)
BuildRequires:  npm(should)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n package


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/package
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/package

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
NODE_ENV=test %{nodejs_sitelib}/mocha/bin/mocha -R spec --require should \
    $(find test -iname '*.test.js')
%endif


%files
%doc Readme.md examples/
%{nodejs_sitelib}/package


%changelog
