Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-passport
Version:        0.4.0
Release:        alt1_6
Summary:        Simple, unobtrusive authentication for Node.js

License:        MIT
URL:            https://github.com/jaredhanson/passport
Source0:        https://github.com/jaredhanson/passport/archive/v%{version}/%{name}-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(mocha)
BuildRequires:  npm(pause)
BuildRequires:  npm(chai)
BuildRequires:  npm(chai-connect-middleware)
BuildRequires:  npm(chai-passport-strategy) >= 0.2.0
BuildRequires:  npm(passport-strategy)
BuildRequires:  npm(proxyquire)
Source44: import.info

%description
Passport is an authentication framework for Connect and Express, which
is extensible through "plugins" known as strategies.

Passport is designed to be a general-purpose, yet simple, modular, and
unobtrusive, authentication framework. Passport's sole purpose is to
authenticate requests. In being modular, it doesn't force any particular
authentication strategy on your application. In being unobtrusive, it
doesn't mount routes in your application. The API is simple: you give
Passport a request to authenticate, and Passport provides hooks for
controlling what occurs when authentication succeeds or fails.


%prep
%setup -q -n passport-%{version}
rm -rf node_modules


%build


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/passport
cp -pr package.json lib %{buildroot}/%{nodejs_sitelib}/passport
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha --reporter spec \
  --require test/bootstrap/node test/*.test.js test/**/*.test.js


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/passport


%changelog
