Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           nodejs-passport-oauth1
Version:        1.1.0
Release:        alt1_8
Summary:        OAuth 1.0 authentication strategy for Passport

License:        MIT
URL:            https://github.com/jaredhanson/passport-oauth1
Source0:        https://github.com/jaredhanson/passport-oauth1/archive/v%{version}/passport-oauth1-%{version}.tar.gz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

BuildRequires:  npm(mocha)
BuildRequires:  npm(chai)
BuildRequires:  npm(chai-passport-strategy)
BuildRequires:  npm(passport-strategy)
BuildRequires:  npm(oauth)
BuildRequires:  npm(utils-merge)
Source44: import.info

%description
General-purpose OAuth 1.0 authentication strategy for Passport.

This module lets you authenticate using OAuth in your Node.js
applications. By plugging into Passport, OAuth authentication can be
easily and unobtrusively integrated into any application or framework
that supports Connect-style middleware, including Express.

Note that this strategy provides generic OAuth support. In many cases,
a provider-specific strategy can be used instead, which cuts down on
unnecessary configuration, and accommodates any provider-specific
quirks. See the list for supported providers.

Developers who need to implement authentication against an OAuth
provider that is not already supported are encouraged to sub-class
this strategy. If you choose to open source the new provider-specific
strategy, please add it to the list so other people can find it.


%prep
%setup -q -n passport-oauth1-%{version}

rm -rf node_modules


%build


%install
mkdir -p %{buildroot}/%{nodejs_sitelib}/passport-oauth1
cp -pr package.json lib %{buildroot}/%{nodejs_sitelib}/passport-oauth1
%nodejs_symlink_deps


%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/mocha/bin/mocha --reporter spec --require test/bootstrap/node test/*.test.js


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/passport-oauth1


%changelog
