Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename preserve

# Disable tests because of dependency on js-beautify, which depends
# on jshint, which has a disallowed license
%global enable_tests 0

Name:		nodejs-preserve
Version:	0.2.0
Release:	alt1_8
Summary:	Substitute tokens in the given `string` , then put them back

License:	MIT
URL:		https://github.com/jonschlinkert/preserve.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz

# Disable one of the tests, as it's depending on old funcionality in js-beautify
# that has since been fixed.  Running the test fails because js-beautify is now
# smarter about the way it does things.
Patch0:		nodejs-preserve_disable-test.patch

BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(should)
BuildRequires:	npm(js-beautify)
%endif
Source44: import.info

%description
Temporarily substitute tokens in the given `string` with placeholders, then
put them back after transforming the string.


%prep
%setup -q -n package

%patch0 -p1

%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json index.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}


%changelog
