Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%bcond_with internet

Name:           nodejs-progress-stream
Version:        2.0.0
Release:        alt1_7
Summary:        Read the progress of a stream

License:        BSD
URL:            https://github.com/freeall/progress-stream
Source0:        https://registry.npmjs.org/progress-stream/-/progress-stream-%{version}.tgz
BuildArch:      noarch

BuildRequires:  rpm-build-nodejs node-devel

%if %{with internet}
BuildRequires:  npm(numeral)
BuildRequires:  npm(request)
BuildRequires:  npm(single-line-log)
BuildRequires:  npm(speedometer)
BuildRequires:  npm(through2)
%endif
Source44: import.info


%description
Read the progress of a stream. Supports speed and eta.

Gets the lengths of the stream automatically if you're using the request
or http module. You can also pass the length on initiation. Progress-stream
will also check to see if the stream already have a length property.


%prep
%setup -q -n package
rm -rf node_modules


%build


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/progress-stream
cp -pr package.json index.js %{buildroot}%{nodejs_sitelib}/progress-stream
%nodejs_symlink_deps


%if %{with internet}
%check
%nodejs_symlink_deps --check
%{__nodejs} test/http.js && %{__nodejs} test/request.js || false
%endif


%files
%doc README.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/progress-stream


%changelog
