Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename promises-aplus-tests
%global enable_tests 1

Name:		nodejs-promises-aplus-tests
Version:	2.1.2
Release:	alt1_8
Summary:	Compliance test suite for Promises/A+

License:	WTFPL
URL:		https://github.com/promises-aplus/promises-tests.git
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source{1-9} are generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source2:	scripts-%{version}.tar.bz2
Source10:	dl-tests.sh

# Grab the readme, as it isn't in the npm tarball
Source11:	https://raw.githubusercontent.com/promises-aplus/promises-tests/%{version}/README.md

BuildArch:	noarch

BuildRequires:	rpm-build-nodejs node-devel
BuildRequires:	npm(underscore)
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
%endif
Source44: import.info

%description
Compliance test suite for Promises/A+


%prep
%setup -q -n package
# setup the tests and scripts
%setup -q -T -D -a 1 -n package
%setup -q -T -D -a 2 -n package
# copy the readme
cp -p %{SOURCE11} .

chmod +x ./lib/cli.js

%nodejs_fixdep mocha
%nodejs_fixdep underscore '^1.8.3'

%build
%{__nodejs} ./scripts/generateTestFiles.js

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json lib/ \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

mkdir -p %{buildroot}%{_bindir}
ln -sf %{nodejs_sitelib}/%{packagename}/lib/cli.js \
    %{buildroot}%{_bindir}/promises-aplus-tests

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
%{_bindir}/mocha -R spec
%else
echo -e "\e[101m -=#=- Tests disabled -=#=- \e[0m"
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE.txt
%{nodejs_sitelib}/%{packagename}
%{_bindir}/promises-aplus-tests



%changelog
