Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


# These tests are interactive so cannot be run in mock.
# Also, I'm not sure why they are failing outside of mock too.
%global enable_tests 0

Name:       nodejs-prompt
Version:    0.2.14
Release:    alt1_10
Summary:    A beautiful command-line prompt for Node.js
License:    MIT
URL:        https://github.com/flatiron/prompt
Source0:    https://registry.npmjs.org/prompt/-/prompt-%{version}.tgz

BuildArch:  noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(read)
BuildRequires:  npm(revalidator)
BuildRequires:  npm(utile)
BuildRequires:  npm(vows)
BuildRequires:  npm(winston)
%endif
Source44: import.info

%description
A beautiful command-line prompt for Node.js. Features include:
 - prompting for user input
 - validation and defaults
 - hiding of passwords


%prep
%setup -q -n package
%nodejs_fixdep utile '^0.3.0'
%nodejs_fixdep winston '~0.7'


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/prompt
cp -pr package.json lib/ \
    %{buildroot}%{nodejs_sitelib}/prompt

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
%{nodejs_sitelib}/vows/bin/vows --spec
%endif


%files
%doc CHANGELOG.md README.md docs/ examples/
%doc --no-dereference LICENSE
%{nodejs_sitelib}/prompt


%changelog
