Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 31
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global packagename proxy-addr
%global enable_tests 1

Name:		nodejs-proxy-addr
Version:	2.0.2
Release:	alt1_6
Summary:	Determine address of proxied request

License:	MIT
URL:		https://github.com/jshttp/proxy-addr
Source0:	https://registry.npmjs.org/%{packagename}/-/%{packagename}-%{version}.tgz
# The test files are not included in the npm tarball.
# Source1 is generated by running Source10, which pulls from the upstream
# version control repository.
Source1:	tests-%{version}.tar.bz2
Source10:	dl-tests.sh


BuildArch:	noarch
%if 0%{?fedora} >= 19
%else
ExclusiveArch: %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:	rpm-build-nodejs node-devel
%if 0%{?enable_tests}
BuildRequires:	mocha node-mocha
BuildRequires:	npm(forwarded)
BuildRequires:	npm(ipaddr.js)
%endif
Source44: import.info

%description
Determine address of proxied request


%prep
%setup -q -n package
# setup the tests
%setup -q -T -D -a 1 -n package

%nodejs_fixdep ipaddr.js '^1.0.3'


%build
# nothing to do!

%install
mkdir -p %{buildroot}%{nodejs_sitelib}/%{packagename}
cp -pr package.json *.js \
	%{buildroot}%{nodejs_sitelib}/%{packagename}

%nodejs_symlink_deps

%check
%nodejs_symlink_deps --check
%{__nodejs} -e 'require("./")'
%if 0%{?enable_tests}
/usr/bin/mocha -R spec --bail --check-leaks test/
%endif


%files
%{!?_licensedir:%global license %doc}
%doc *.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/%{packagename}



%changelog
