Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-nodejs
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}


%global enable_tests 1

Name:           nodejs-q-io
Version:        1.13.4
Release:        alt1_5
Summary:        Interfaces for IO using Q promises in JavaScript on Node.js
License:        MIT
URL:            https://github.com/kriskowal/q-io
Source0:        https://github.com/kriskowal/q-io/archive/v%{version}/q-io-%{version}.tar.gz
# Patch out tests that need internet access
Patch0:         nodejs-q-io-internet.patch
BuildArch:      noarch

%if 0%{?fedora} >= 19
%else
ExclusiveArch:  %{ix86} x86_64 %{arm} noarch
%endif

BuildRequires:  rpm-build-nodejs node-devel

%if 0%{?enable_tests}
BuildRequires:  npm(jasmine-node)
BuildRequires:  npm(collections)
BuildRequires:  npm(mime)
BuildRequires:  npm(mimeparse)
BuildRequires:  npm(q)
BuildRequires:  npm(qs)
BuildRequires:  npm(url2)
%endif
Source44: import.info

%description
%{summary}.


%prep
%setup -q -n q-io-%{version}
%patch0 -p1

%nodejs_fixdep collections "^1.0.2"
%nodejs_fixdep mime
%nodejs_fixdep qs "^6.0.2"
%nodejs_fixdep url2 "^1.0.0"


%build
#nothing to do


%install
mkdir -p %{buildroot}%{nodejs_sitelib}/q-io
# fs-boot was previously a separate module but has now been merged into q-io.
# The fs-boot website (https://github.com/kriskowal/fs-boot) has this advice:
#   -- "Out of service — Please use Q-IO instead"
cp -pr package.json \
    buffer-stream.js deprecate.js \
    fs2http.js fs.js fs-boot.js fs-common.js fs-mock.js fs-root.js \
    http-apps/ http-apps.js http-cookie.js http.js reader.js writer.js \
    %{buildroot}%{nodejs_sitelib}/q-io

%nodejs_symlink_deps


%if 0%{?enable_tests}
%check
%nodejs_symlink_deps --check
/usr/bin/jasmine-node spec
%endif


%files
%doc README.md CHANGES.md
%doc --no-dereference LICENSE
%{nodejs_sitelib}/q-io


%changelog
